<?php

defined('_JEXEC') or die('Restricted Access');

/* Sitemap cache plugin for Joomla!
--------------------------------------------------------------
 Copyright (C) 2017 Addon Dev. All rights reserved.
 Website: https://addondev.com
 GitHub: github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: April 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */

class PlgSystemSitemapcacheInstallerScript
{
	public function preflight($type, $parent)
	{
		$app = JFactory::getApplication();
		$dbo = JFactory::getDbo();
		
		$minJVersion = '1.0';
		$minPHPVersion = '4.0';
		
		if(version_compare(JVERSION, $minJVersion, '<'))
		{
			$app->enqueueMessage(JText::sprintf('PLG_SITEMAPCACHE_JOOMLA_VERSION_CHECK_FAILURE', $minJVersion), 'error');
			return false;
		}
		
		if(version_compare(PHP_VERSION, $minPHPVersion, '<'))
		{
			$app->enqueueMessage(JText::sprintf('PLG_SITEMAPCACHE_PHP_VERSION_CHECK_FAILURE', $minPHPVersion), 'error');
			return false;
		}
		
		$manifest = method_exists($parent, 'get') ? $parent->get('manifest') : $parent->getManifest();
		$update_server = (string) $manifest->updateservers->server;
		$old_update_server = 'http://addondev.com/support/updates/sitemapcache.xml';
		
		if($update_server && preg_match('#^((?:https?:)?//[^/]+/[^\?]+?\.\w+)(?:\?(.*))?#i', $update_server, $server))
		{
			$update_server_ref = $update_server;
			$ref = '_' . urlencode(JUri::getInstance()->getHost());
			
			if(!empty($server[2]) && strpos($update_server_ref, $ref) === false)
			{
				$update_server_ref .= $ref;
			}
			
			if(strcasecmp($update_server, $update_server_ref))
			{
				$manifest->updateservers->server = $update_server_ref;
				JFile::write(__DIR__ . '/sitemapcache.xml', $manifest->asXML());
			}
		
			$dbo = JFactory::getDbo();
			
			$dbo->setQuery($dbo->getQuery(true)
				->SELECT('update_site_id')
				->FROM($dbo->quoteName('#__update_sites'))
				->WHERE($dbo->quoteName('location') . ' LIKE ' . $dbo->quote($server[1] . '%'))
				->WHERE($dbo->quoteName('location') . ' <> ' . $dbo->quote($update_server_ref))
			);
			
			if($update_ids = $dbo->loadObjectList())
			{
				foreach($update_ids as &$element)
				{
					$element = (int) $element->update_site_id;
				}
				
				$update_ids = implode(',', $update_ids);
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__update_sites'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__update_sites_extensions'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__updates'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
			}
		}
	}
}
