
/* Random Quote extension for Joomla!
--------------------------------------------------------------
 Copyright (C) 2021 AddonDev. All rights reserved.
 Website: https://addondev.com
 GitHub: github.com/philip-sorokin
 Developer: Philip Sorokin
 E-mail: philip.sorokin@gmail.com
 Created: March 2021
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */

function QuoteBox( module, params ) {

	"use strict";
	
	var w = window, d = w.document, root = d.documentElement, 
		childs = module.getElementsByTagName('div'), quotes = [];
	
	var q = {
		container: childs[0],
		scrollBar: childs[1],
		rail: childs[2],
		outer: childs[3],
		height: params.containerHeight - params.barHeight,
		scrollVisible: null,
		touchStart: null,
		touchEnd: null,
		step: null
	};
	
	function updateScroll() {
		q.outer.scrollTop = 0;
		q.scrollBar.style.top = '0px';
		q.scrollVisible = q.outer.clientHeight + 15 < q.quotesBlock.clientHeight ? true : false;
		q.scrollBar.style.display = q.scrollVisible ? 'block' : '';
		q.step = q.outer.clientHeight / q.outer.scrollHeight * 50;
	}
	
	function preventDefault(e) {
		e = e || w.event;
		e.returnValue = e.preventDefault ? e.preventDefault() : false;
	}
	
	q.scrollBar.onmousedown = function(e) {
		
		e = e || w.event;
		
		var onselectstart = d.onselectstart || '',
			onmousemove = d.ononmousemove || '',
			onmouseup = d.onmouseup || '';
		
		preventDefault(e);
		
		d.onselectstart = preventDefault;
		d.onmousemove = scrollTouchMove;
		q.container.ondragstart = preventDefault;
		q.container.style.cursor = "pointer";
		
		d.onmouseup = function() {
			d.onselectstart = onselectstart;
			d.onmousemove = onmousemove;
			d.onmouseup = onmouseup;
			q.container.ondragstart = '';
			q.container.style.cursor = '';
		};
		
	};
	
	q.outer.ontouchmove = scrollTouchMove;
	q.outer.ontouchstart = touchStart;
	
	if ( 'onwheel' in d ) {
		q.outer.onwheel = scrollTouchMove;
	} else if ( 'onmousewheel' in d ) {
		q.outer.onmousewheel = scrollTouchMove;
	} else if ( 'DOMMouseScroll' in d ) {
		q.outer.addEventListener( 'DOMMouseScroll', scrollTouchMove, false );
	}
	
	function touchStart(e) {
		e = e || w.event;
		if ( q.scrollVisible ) {
			preventDefault(e);
			q.touchStart = e.touches[0].pageY,
			q.touchEnd = q.scrollBar.offsetTop;
		}
	}
	
	function scrollTouchMove(e) {
		e = e || w.event;
		if ( q.scrollVisible ) {
			preventDefault(e);
			var deltaY = e.deltaY || e.detail || -e.wheelDelta || 0;
			if ( deltaY > 0 ) {
				q.scrollBar.style.top = (q.scrollBar.offsetTop >= q.height - q.step) ? (q.height + 'px') : (q.scrollBar.offsetTop + q.step + 'px');
			} else if ( deltaY < 0 ) {
				q.scrollBar.style.top = (q.scrollBar.offsetTop >= q.step) ? (q.scrollBar.offsetTop - q.step + 'px') : '0px';
			} else {
				if ( e.type === 'touchmove' ) {
					var y = q.touchStart + q.touchEnd - e.touches[0].pageY,
						shift = y > q.height ? q.height : (y < 0 ? 0 : y);
				} else if ( e.type === 'mousemove' ) {
					var y = e.pageY ? e.pageY : (e.clientY + d.body.scrollTop + root.scrollTop),
						offset = root.clientTop || d.body.clientTop || 0, element = q.container;
					do { offset += element.offsetTop || 0 } while ( element = element.offsetParent );
					var pos = y - offset - params.barHeight / 2,
						shift = pos < 0 ? 0 : (pos > q.height ? q.height : pos);
				}
				q.scrollBar.style.top = shift + 'px';
			}
			q.outer.scrollTop = q.scrollBar.offsetTop / q.height * (q.outer.scrollHeight - q.outer.clientHeight)
		}
	}
	
	var transition = function() {
		for ( var i=0; i<arguments.length; i++ ) {
			if ( arguments[i] in root.style ) {
				return arguments[i];
			}
		}
	}('transition', '-webkit-transition', '-moz-transition', '-o-transition');
	
	var fade = transition ? function( el, duration, out ) {
		el.style.opacity = Number(out);
		setTimeout(function() {
			el.style[transition] = 'opacity ' + (duration - 16) + 'ms ease-in';
			el.style.opacity = Number(!out);
		}, 16)
	} : function(){return false};
	
	function count( n, i, l ) {
		for ( i=l=0; i<n.childNodes.length; i++ ) {
			if ( n.childNodes[i].nodeType == 3 ) {
				l += n.childNodes[i].nodeValue.length;
			} else {
				l += count(n.childNodes[i]);
			}
		}
		return l;
	}
	
	function addText( xmlNode, parent, className, first ) {
		var p = d.createElement('p'),
			content = (new XMLSerializer().serializeToString(xmlNode)).replace(/^<[^>]+>|<[^>]+>$/gi, "");
		if ( first ) {
			var leftMark = '<span class="qBox-quote-symbol qBox-quote-symbol-left">\u201C</span>',
				rightMark = '<span class="qBox-quote-symbol qBox-quote-symbol-right">\u201D</span>';
			p.innerHTML = (d.documentElement.getAttribute('dir') === 'rtl') ? (rightMark + content + leftMark) : (leftMark + content + rightMark);
		} else {
			p.innerHTML = content;
		}
		p.className = className;
		parent.appendChild(p);
	}
	
	function setValue( quote, outer ) {
		var quoteText = quote.getElementsByTagName('text')[0],
			quoteAuth = quote.getElementsByTagName('author')[0];
		if ( quoteText && quoteText.childNodes.length ) {
			if ( q.quotesBlock ) {
				q.quotesBlock.parentNode.removeChild(q.quotesBlock);
			}
			q.quotesBlock = d.createElement('table');
			var tr = q.quotesBlock.insertRow(0),
				td = tr.insertCell(0);
			addText( quoteText, td, 'qBox-quote-text', true );
			if ( quoteAuth && quoteAuth.childNodes.length ) {
				addText( quoteAuth, td, 'qBox-quote-author' );
			}
			outer.appendChild(q.quotesBlock);
		}
	}
	
	function createMessage(message) {
		var quote = d.createElement('quote'),
			text = d.createElement('text'),
			msg = d.createTextNode(message);
		quote.appendChild(text);
		text.appendChild(msg);
		return quote;
	}
	
	var pause, _this = this, speed = 100000;
	
	this.pause = function() {
		pause = true;
		return 'Pause';
	};
	
	this.resume = function() {
		if (pause) {
			pause = false;
			_this.cycle && _this.cycle();
			return 'Resumed';
		}
		return 'Already started';
	};
	
	function getFile(file, callback)
	{
		var req = new XMLHttpRequest();
		req.onreadystatechange = function() {
			req.readyState == 4 && callback(req);
		};
		req.open('GET', file, true);
		req.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
		req.send(null);
	}
	
	if (params.xmlURL)
	{
		getFile(params.xmlURL, function(req)
		{
			if (req.responseXML)
			{
				quotes = req.responseXML.documentElement.getElementsByTagName('quote');
				
				if (quotes.length)
				{
					speed = params.speed || 100;
				}
				else
				{
					quotes = [createMessage('Your XML file is empty.')];
				}
			}
			else
			{
				quotes = [createMessage(req.status == 200 ? 'Your XML file is not valid.' : 'The XML file not found.')];
			}
			
			init(quotes);
		});
	}
	else if (params.tsvURL)
	{
		getFile(params.tsvURL, function(req)
		{
			var matches = null,
				quotes = [];
				
			if (matches = req.responseText.match(/^.+$/gm))
			{
				for (var i = 0, line = null; i < matches.length; i++)
				{
					if (line = matches[i].match(/^\s*(\S[^\t]*)(?:\t\s*(\S.+?)\s*)$/))
					{
						quotes.push(createQuote(line[1], line[2]));
					}
				}
			}
			
			if (quotes.length)
			{
				speed = params.speed || 100;
			}
			else
			{
				quotes = [createMessage('No quotes defined.')];
			}
			
			init(quotes);
		});
	}
	else
	{
		params.json = JSON.parse(params.json);
		
		for(var i=0; i < params.json.length; i++)
		{
			quotes.push(createQuote(params.json[i].text, params.json[i].author));
		}
		
		if (quotes.length)
		{
			speed = params.speed || 100;
		}
		else
		{
			quotes = [createMessage('No quotes defined.')];
		}
		
		init(quotes);
	}
	
	function createQuote(t, a)
	{
		var quote = d.createElement('quote'),
			text = d.createElement('text'),
			author = d.createElement('author');
		
		text.innerHTML = t;
		author.innerHTML = a;
		
		quote.appendChild(text);
		quote.appendChild(author);
		
		return quote;
	}
	
	function init(quotes)
	{
		var delayIn = 1000, 
			delayOut = 1000,
			mult = speed / 100,
			fantom = [];
			
		_this.cycle = function() {
			if ( !fantom.length ) {
				for ( var i=0, len=quotes.length; i<len; i++ ) {
					fantom.push(i);
				}
			}
			var idx = fantom.splice(Math.floor(Math.random()*(fantom.length-1)), 1)[0];
			setValue( quotes[idx], q.outer );
			var len = count( q.quotesBlock ),
				correct = 50 / len * 85,
				timer = (len + correct) * 45 * mult;
			fade( q.quotesBlock, delayIn, false );
			
			updateScroll();
			
			setTimeout(function() {
				if (!pause) {
					fade( q.quotesBlock, delayOut, true );
					setTimeout( _this.cycle, delayOut );
				}
			}, timer + delayIn);
		};
		
		_this.cycle();
	}
}