<?php

defined('_JEXEC') or die;

/* Random Quote extension for Joomla!
--------------------------------------------------------------
 Copyright (C) 2021 AddonDev. All rights reserved.
 Website: https://addondev.com
 GitHub: github.com/philip-sorokin
 Developer: Philip Sorokin
 E-mail: philip.sorokin@gmail.com
 Created: March 2021
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */

require_once __DIR__ . '/helper.php';

$doc = JFactory::getDocument();
$id = modRandom_quoteHelper::getID();

$version = filemtime('modules/mod_random_quote/mod_random_quote.xml');

$doc->addScript("modules/mod_random_quote/assets/js/random-quote.js", ['version' => $version], ['defer' => 'defer']);
$doc->addStylesheet("modules/mod_random_quote/assets/css/random-quote.css", ['version' => $version]);

$fontSize = $params->get('fontSize');
$symbol = $fontSize * 3;
$leftMarkPadding = round( ($fontSize / 100) * $params->get('leftMarkPadding') );
$rightMarkPadding  = round( ($fontSize / 100) * $params->get('rightMarkPadding') );
$vAlign = round( $fontSize * 1.05) ;

$barHeight = $params->get('scrollbarHeight');
$containerHeight = $params->get('containerHeight');

if ($params->get('defaultDesign') == 1)
{
	$doc->addStyleDeclaration('
	
		.qBox-module {
			padding: 13px 15px;
			background-color: #FAFAFA;
			border: 1px solid #DADADA;
			border-radius: 3px;
			box-shadow: 0 1px 0 rgb(0 0 0 / 5%);
		}

		.qBox-module h4 {
			color: #0B4C8C;
			border-bottom: 3px solid #D5E6F7;
			font-size: 16px;
			margin-top: 0;
			margin-bottom: 15px;
			padding: 0 0 4px 8px;
			font-weight: bold;
		}
		html[dir="rtl"] .qBox-module h4 {
			direction: rtl;
			text-align: right;
		}
	');
}

$doc->addStyleDeclaration("
	#qBox-module_$id .qBox-quote, #qBox-module_$id .qBox-scroll-rail {height: {$containerHeight}px;}
	#qBox-module_$id .qBox-scroll-bar {background: {$params->get('scrollbarBG')}; height: {$barHeight}px;}
	#qBox-module_$id .qBox-scroll-rail {background: {$params->get('railBG')};}
	#qBox-module_$id .qBox-quote {color: {$params->get('textColor')};}
	" . ($params->get('quoteBG') ? "#qBox-module_$id .qBox-quote table {background: {$params->get('quoteBG')};}" : '') . "
	#qBox-module_$id {font-size: {$fontSize}px; font-family: '{$params->get('textFontFamily')}';}
	#qBox-module_$id .qBox-quote-symbol {vertical-align: -{$vAlign}px; font-size: {$symbol}px; font-family: '{$params->get('qMarksFontFamily')}';}
	#qBox-module_$id .qBox-quote-symbol-left {padding-right: {$leftMarkPadding}px;}
	#qBox-module_$id .qBox-quote-symbol-right {padding: 0 {$leftMarkPadding}px 0 {$rightMarkPadding}px;}
");

$file = '';
$json = '';
$speed = $params->get('speed');
$dataSource = $params->get('dataSource');

if ($dataSource == 1)
{
	$json = str_replace(['\r\n', '\r', '\n'], '', str_replace("'", "\\'", json_encode(array_values((array) $params->get('quotes')), JSON_UNESCAPED_UNICODE)));
	$source = "json: '$json'";
}
else
{
	$rel  = preg_replace("#^(?:(?:https?:)?//[^/]+/|/)#i", '', $dataSource == 2 ? $params->get('quoteXML') : $params->get('quoteTSV'));
	
	$file  = JUri::root(true) . '/' . $rel;
	$file .= '?' . md5(filemtime($rel));
	
	$source = $dataSource == 2 ? "xmlURL: '$file'" : "tsvURL: '$file'";
}

$settings = "{{$source}, containerHeight: $containerHeight, barHeight: $barHeight, speed: $speed}";

$doc->addScriptDeclaration("
	(function(w, d){
		var root = d.documentElement, id = 1;
		function start() {
			var module = d.getElementById('qBox-module_' + id++ );
			if ( module ) {
				w['quoteBox_' + (id - 1)] = new QuoteBox(module, $settings);
				start();
			}
		}
		if (w.jQuery) {
			jQuery(start);
		} else {
			d.readyState === 'complete' ? start() : d.addEventListener('DOMContentLoaded', start, false);
		}
	})(window, document);
");

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''));

require JModuleHelper::getLayoutPath('mod_random_quote', $params->get('layout', 'default'));
