<?php

defined('_JEXEC') or die('Restricted access');

/* Lazy Slider for Joomla!
--------------------------------------------------------------
 Copyright (C) 2017 AddonDev. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: October 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */


class ModLazysliderInstallerScript
{
	public function preflight($type, $parent)
	{
		$app = JFactory::getApplication();
		
		$minJVersion = '3.6.5';
		$minPHPVersion = '5.4';
		
		if(version_compare(JVERSION, $minJVersion, '<'))
		{
			$error = JText::sprintf('MOD_LAZYSLIDER_JOOMLA_VERSION_CHECK_FAILURE', $minJVersion);
		}
		
		if(version_compare(PHP_VERSION, $minPHPVersion, '<'))
		{
			if (isset($error)) {
				$error .= '<br/>';
			}
			$error .= JText::sprintf('MOD_LAZYSLIDER_JOOMLA_VERSION_CHECK_FAILURE', $minPHPVersion);
		}
		
		if(isset($error))
		{
			$app->enqueueMessage($error, 'error');
			$parent->getParent()->message = '';
			return false;
		}
	}
}
