
/** JSLazyLoading extension for Joomla!
---------------------------------------------------------------
 Copyright (C) 2015 Philip Sorokin. All rights reserved
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Email: philip.sorokin@gmail.com
 Created: June 2015
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */

(function(w, d) {
	
	'use strict';
	
	function forEach(collection, callback) {
		for (var i = 0, len = collection.length; i < len; i++) {
			if (collection[i] && callback(collection[i], i) === false) {
				break;
			}
		}
		return collection;
	}
	
	function getFields(names) {
		var fields = [];
		forEach(names, function(name) {
			var field = d.getElementById('jform_params_' + name);
			if (field) {
				fields.push(field);
			}
		});
		return fields;
	}
	
	function validateFields(fieldNames, subRex, pattern, replacement) {
		subRex = subRex ? '|' + subRex : '';
		if (typeof fieldNames === 'string') {
			fieldNames = [fieldNames];
		}
		forEach(getFields(fieldNames), function(field) {
			field.addEventListener('blur', function()
			{
				do {
					var value = this.value;
					this.value = value.replace(new RegExp('^[,\\s]+|[,\\s]+$' + subRex, 'g'), '');
				}
				while(this.value !== value);
				
				this.value = this.value.replace(new RegExp('(\\s*,[\\s]*)+', 'g'), ', ');
				
				if (pattern && replacement) {
					this.value = this.value.replace(new RegExp(pattern, 'g'), replacement);
				}
			});
		});
	}
	
	d.addEventListener('DOMContentLoaded', function()
	{	
		validateFields('botlist');
		validateFields(['excludeClasses', 'includeClasses'], '[^\\w\\-\\,]');
		validateFields(['globalExclusions', 'globalInclusions'], '\\s');
		validateFields('clientSideExclusion', '[^\\w\\-\\.\\,#]');
		
		validateFields([
			'loadingInterval', 'rangeY', 'rangeX', 'fadeInDuration',
			'breakpoint_1_width_value', 'breakpoint_2_width_value', 'breakpoint_3_width_value', 
			'breakpoint_1_density_value', 'breakpoint_2_density_value', 'breakpoint_3_density_value'
		], '[^\\d]');
		
		validateFields([
			'breakpoint_1_width_postfix', 'breakpoint_2_width_postfix', 'breakpoint_3_width_postfix', 
			'breakpoint_1_density_postfix', 'breakpoint_2_density_postfix', 'breakpoint_3_density_postfix'
		], '[^\\w-]+', '^(?=(?!_).)', '_');
		
		validateFields([
			'breakpoint_1_width_attribute', 'breakpoint_2_width_attribute', 'breakpoint_3_width_attribute', 
			'breakpoint_1_density_attribute', 'breakpoint_2_density_attribute', 'breakpoint_3_density_attribute'
		], '[^\\w-]+', '^(?=(?!data-).)', 'data-');
	});
	
})(window, document);
