<?php 

/** JSLazyLoading extension for Joomla!
---------------------------------------------------------------
 Copyright (C) 2015 Philip Sorokin. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Email: philip.sorokin@gmail.com
 Created: June 2015
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */


defined('_JEXEC') or die('Restricted access');


class PlgSystemJslazyloading extends JPlugin
{
	PRIVATE 
		$_rootURI = "",
		$_placeholder = "",
		$_execute = false,
		$_restore = false,
		$_excluded_scripts = array(),
		$_excluded_blocks = array(),
		$_scriptExecutionTime = false;
	
	
	PROTECTED FUNCTION isSite()
	{
		$app = JFactory::getApplication();
		
		return method_exists($app, 'isSite') ? $app->isSite() : $app->isClient('site');
	}
	
	
	PUBLIC FUNCTION __construct(&$subject, $config)
    {
		parent::__construct($subject, $config);
		$this->loadLanguage('', JPATH_ADMINISTRATOR);
    }
	
	
	PUBLIC FUNCTION onAfterDispatch()
	{
		if(($this->params->get('backendUsage') || $this->isSite()) && 
			JFactory::getDocument()->getType() === 'html' && !$this->_exclusions())
		{
			$this->_execute = true;
		}
	}
	
	
	PUBLIC FUNCTION onBeforeCompileHead()
	{
		if($this->_execute && !$this->_restore)
		{	
			// If selected, get a timestamp for debugging.
			if($this->_scriptExecutionTime = $this->_getParam('scriptExecutionTime'))
			{
				$this->_countScriptExecutionTime();
			}
			
			$this->_rootURI = JURI::root(true);
			
			// Fetch client params
			
			$client_params = array();
			
			if ($value = $this->_getParam($name = 'dynamicMode')) {
				$client_params[] = "$name:" . $value;
				if ($value = $this->_getParam($name = 'rangeX')) {
					$client_params[] = "$name:" . $value;
				}
			}
			if ($value = $this->_getParam($name = 'rangeY')) {
				$client_params[] = "$name:" . $value;
			}
			if ($value = $this->_getParam($name = 'topBorder')) {
				$client_params[] = "$name:" . $value;
			}
			if ($value = $this->_getParam($name = 'fadeInEffect')) {
				$client_params[] = "$name:" . ($value == 2 ? "'desktop'" : 1);
				if ($value = $this->_getParam($name = 'fadeInDuration')) {
					$client_params[] = "$name:" . $value;
				}
			}
			if (($name = 'loaderImage') && $this->_getParam('loaderImageSwitcher')) {
				if ($value = $this->_getParam($name)) {
					$client_params[] = "$name:'" . $value . "'";
				}
			} else {
				$client_params[] = "$name:null";
			}
			if ($value = $this->_getParam($name = 'backgroundColor')) {
				$client_params[] = "$name:'" . $value . "'";
			}
			if ($value = $this->_getParam($name = 'softMode')) {
				$client_params[] = "$name:" . $value;
			}
			if ($this->_getParam($name = 'sequentialLoading')) {
				$client_params[] = "$name:" . $this->_getParam('loadingInterval');
			}
			if ($value = $this->_getParam($name = 'clientSideExclusion')) {
				$client_params[] = "$name:['" . str_replace(', ', "','", $value) . "']";
			}
			if ($value = $this->_getParam($name = 'ajaxListener')) {
				$client_params[] = "$name:" . $value;
			}
			
			// Fetch multi-serving params
			if($mode = $this->_getParam('multiServingMode'))
			{
				$client_params = array_merge($client_params, $this->_fetchMultiservingParams($mode));
			}
			
			$client_params = !empty($client_params) ? '{' . implode(',', $client_params) . '}' : '';
			
			if($this->_rootURI)
			{
				if (!$client_params) {
					$client_params = "null";
				}
				$client_params .= ",'{$this->_rootURI}'";
			}
			
			// Get the document object.
			$doc = JFactory::getDocument();
			
			// Define the assets
			$assets  = '<script type="text/javascript" src="' . $this->_rootURI . '/plugins/system/jslazyloading/assets/js/jslazyloading_v3.5.min.js" defer="defer"></script>';
			$assets .= '<script type="text/javascript">' . "(function(d){function start(){if(typeof JSLazyLoading !== 'undefined'){window.jsLazy = new JSLazyLoading($client_params)}} d.readyState === 'complete' ? start() : d.addEventListener('DOMContentLoaded', start, false)})(document);" . '</script>';
			
			if($this->_getParam('noScriptSupport'))
			{
				$assets .= '<script type="text/javascript">function JSLazyLoadingRestoreID(){var d = document, last = d.images[d.images.length-1], temp = "data-nscr-id"; if(last){var id = last.getAttribute(temp); if(id){last.id = id; last.removeAttribute(temp)}}}</script>';
				$assets .= '<noscript><style type="text/css">.jsll-noscript + img {display:none!important}</style></noscript>';
			}
			
			// Add the assets
			$doc->addCustomTag($assets);
			
			// If selected, check the script execution time
			if($this->_scriptExecutionTime)
			{
				$this->_countScriptExecutionTime();
			}
		}
		
	}


	PUBLIC FUNCTION onAfterRender()
	{
		if($this->_execute)
		{
			// If selected, get a timestamp for debugging.
			if($this->_scriptExecutionTime)
			{
				$this->_countScriptExecutionTime();
			}
			
			// Get the application object
			$app = JFactory::getApplication();
			
			// Get the HTML.
			$html = $app->getBody();
			
			$stamp = rand(0, 1000000);
			
			$excluded_script_placeholder = "JSLL_S_{$stamp}";
			$excluded_block_placeholder = "JSLL_B_{$stamp}";
			
			$html = preg_replace_callback("#<((?:no)?script)[^>]*>.*</\\1\s*>#isU", function($m) use($excluded_script_placeholder) {
				$this->_excluded_scripts[] = $m[0];
				return $excluded_script_placeholder;
			}, $html);
			
			$reverse_pattern = "#(<img[^>]+)data-(src[^>]+>)#isU";
			
			if($this->_restore)
			{
				if(!$this->_getParam('setPlaceholder'))
				{
					$html = preg_replace("#<(img)(?=[^>]+data-src)([^>]*['\"\s])src\s*=\s*['\"][^'\"]+['\"]([^>]*)>#isU", "<$1$2$3>", $html);
				}
				$html = preg_replace($reverse_pattern, "$1$2", $html);
			}
			else
			{
				// Set the placeholder: a transparent 1x1 gif
				//$this->_placeholder = '"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"';
				
				// Set the placeholder: a transparent 3x2 png
				$this->_placeholder = '"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAACCAQAAAA3fa6RAAAADklEQVR42mNkAANGCAUAACMAA2w/AMgAAAAASUVORK5CYII="';
				
				if($this->_getParam('rewritingMode') == "1")
				{
					if ($this->_getParam('noScriptSupport')) {
						$cnt = $this->_replaceNoscript($reverse_pattern, "<noscript class='jsll-noscript'>$1$2</noscript/>$0", $html);
					}
					if ($this->_getParam('setPlaceholder')) {
						$html = preg_replace("#<(img)([^>]+data-src[^>]+)>#isU", "<$1 src={$this->_placeholder}$2>", $html, -1, $cnt);
					}
				}
				else
				{
					if($this->_getParam('excludingTags'))
					{
						$startTag = str_ireplace('&gt;', '>', str_ireplace('&lt;', '<', $this->_getParam('startTag')));
						$endTag = str_ireplace('&gt;', '>', str_ireplace('&lt;', '<', $this->_getParam('endTag')));
						
						$html = preg_replace_callback("#" . preg_quote($startTag, "#") . ".+" . preg_quote($endTag, "#") . "#isU", function($m) use($excluded_block_placeholder) {
							$this->_excluded_blocks[] = $m[0];
							return $excluded_block_placeholder;
						}, $html);
					}
					
					if($this->_getParam('criteria'))
					{
						$classes = $this->_getParam('includeClasses');
						$statement = "?=";
					}
					else
					{
						$classes = $this->_getParam('excludeClasses');
						$statement = "?!";
					}
					
					$assertion = $classes ? "({$statement}[^>]*[\s'\"]class\s*=\s*['\"][^'\"]*(?:" . 
							str_replace(", ", "|", preg_quote($classes, "#")) . ")[^'\"]*['\"])" : "";
					
					$pattern = "#(<img{$assertion}[^>]*['\"\s])(src\b[^>]+>)#isU";
					
					if ($this->_getParam('noScriptSupport')) {
						$cnt = $this->_replaceNoscript($pattern, "<noscript class='jsll-noscript'>$0</noscript/>$1src={$this->_placeholder} data-$2", $html);
					} else {
						$html = preg_replace($pattern, "$1src={$this->_placeholder} data-$2", $html, -1, $cnt);
					}
					
					if(!empty($this->_excluded_blocks))
					{
						$html = preg_replace_callback("#$excluded_block_placeholder#", function($m) {
							return array_shift($this->_excluded_blocks);
						}, $html);
					}
					
				}
				
				if ($this->_getParam('softMode'))
				{
					$subpattern = "(?:width|height)\s*=\s*['\"][^\"']+['\"]";
					$html = preg_replace("#<(img(?=[^>]+data-src)[^>]*[\s'\"])($subpattern)([^>]*[\s'\"])($subpattern)([^>]*)>#isU", "<$1data-$2 $2$3data-$4 $4$5>", $html);
				}
				
				$html = preg_replace("#<img[^>]+data\-src\s*=\s*['\"](?!(https?:)?//|/)#is", "$0" . JUri::root(true) . '/', $html);
				
				if($this->_getParam('backgroundImages'))
				{					
					$assert = '<script>document.write(\'<style id="jsll-nobackground" type="text/css">* {background-image: none !important}</style><style type="text/css">[data-jsll-nobackground] {background-image: none !important}</style>\');</script>';
					
					$html = preg_replace('#<head(\s+[^>]+)?>#i', "$0\n" . $assert, $html);
				}
			}
			
			if(!empty($this->_excluded_scripts))
			{
				$html = preg_replace_callback("#$excluded_script_placeholder#", function($m) {
					return array_shift($this->_excluded_scripts);
				}, $html);
			}
			
			// If selected, finish debugging and get script execution time.
			if($this->_scriptExecutionTime)
			{
				$html = $this->_countScriptExecutionTime($html);
			}
			
			// Set modified HTML.
			$app->setBody($html);
			
		}
	}
	
	
	PRIVATE FUNCTION _fetchMultiservingParams($mode)
	{	
		switch($this->_getParam('multiServingType'))
		{
			case 1 : $type = 'density'; $unit = 'dpi';
				break;
			case 0 :
				default : $type = 'width'; $unit = 'px';
		}
		
		switch($mode)
		{
			case 1 : $attr = 'postfix'; $handler = $this->_getParam('multiServingHandler') ? 'php' : 'server';
				break;
			case 0 :
				default : $attr = 'attribute'; $handler = 'manual'; 
		}
		
		for($i = 1, $params = array(), $breakpoints = array(); ; $i++)
		{
			$breakpointType  = "breakpoint_{$i}_{$type}";
			$breakpointMode  = "breakpoint_{$i}_{$type}_{$attr}";
			$breakpointValue = "breakpoint_{$i}_{$type}_value";
			
			if($type = $this->_getParam($breakpointType))
			{
				if($property = $this->_getParam($breakpointMode))
				{
					if($value = $this->_getParam($breakpointValue))
					{
						$breakpoints[] = "'$property':'{$value}{$unit}'";
					}
				}
			}
			else if(is_null($type))
			{
				break;
			}
		}
		
		if(!empty($breakpoints))
		{	
			$params['multiServing'] = "multiServing:'$handler'";
			$params['multiServingType'] = "multiServingType:'$type'";
			$params['multiServingBreakpoints'] = "multiServingBreakpoints:" . "{" . implode(',', $breakpoints) . "}";
		}
		
		return $params;
		
	}
	
	
	PRIVATE FUNCTION _replaceNoscript($pattern, $replacement, &$html)
	{
		$html = preg_replace($pattern, $replacement, $html, -1, $cnt);
		if ($cnt) {
			$html = preg_replace("#</noscript/>(<img[^>]*['\"\s])(id\s*=[^>]+>)#isU", "</noscript>$1data-nscr-$2<script>JSLazyLoadingRestoreID()</script>", $html);
		}
		$html = str_replace("</noscript/>", "</noscript>", $html);
		return $cnt;
	}
	
	
	PRIVATE FUNCTION _countScriptExecutionTime($html = null)
	{
		static $result = array(), $format = 5;
		
		$backtrace = debug_backtrace();
		$caller = $backtrace[1]['function'];
		
		$result[$caller] = !isset($result[$caller]) ? microtime(true) : 
			number_format((microtime(true) - $result[$caller]), $format);
		
		if($html)
		{
			$total = number_format((array_sum($result)), $format);
			$notice = __CLASS__ . ' (PHP script execution time):';
			
			if($this->_scriptExecutionTime == 1)
			{
				$notice = "\\n {$notice}";
				foreach($result as $name => $time)
				{
					$notice .= "\\n $name: $time sec.";
				}	
				$notice .= "\\n Total execution time: {$total} sec.";
				return preg_replace('#</head>#', "<script>if('console' in window && console.log) console.log('$notice')</script>$0", $html);
			}
			else
			{
				$notice = "<div><p style='margin: 15px; text-align: left'>{$notice}";
				foreach($result as $name => $time)
				{
					$notice .= "<br>$name: $time sec.";
				}	
				$notice .= "<br>total execution time: <b>{$total} sec.</b></div>";
				return preg_replace('#<body[^>]*>#', "$0{$notice}", $html);
			}
		}
		
	}
	
	
	PRIVATE FUNCTION _matchParams($params)
	{
		$match = false;
		$list = explode(', ', $params);
		$input = JFactory::getApplication()->input;
		
		foreach($list as $groups)
		{
			$params = explode('&', $groups);
			
			foreach($params as $nameValue)
			{
				$nameValue = explode('=', $nameValue);
				$name = $nameValue[0];
				
				if($values = isset($nameValue[1]) ? $nameValue[1] : null)
				{
					if(strpos($values, '(') === 0)
					{
						$values = substr($values, 1, strlen($values) - 2);
						$values = explode('|', $values);
					}
					else
					{
						$values = array($values);
					}
					
					foreach($values as $value)
					{
						if($match = $input->get($name) == $value)
						{
							break;
						}
					}
				}
				
				if(!$match)
				{
					break;
				}
				
			}
			
			if($match)
			{
				break;
			}
			
		}
		
		return $match;
		
	}
	
	
	PRIVATE FUNCTION _exclusions()
	{
		$match = (
			$this->_getParam('bots') && 
				$this->_getParam('botlist') && 
					!empty($_SERVER['HTTP_USER_AGENT']) &&
						preg_match("#" . str_replace(", ", "|", preg_quote($this->_getParam('botlist'), "#")) . "#i", $_SERVER['HTTP_USER_AGENT'])
		) || (
			$this->_getParam('globalExclusions') && 
				$this->_matchParams($this->_getParam('globalExclusions'))
		);
		
		if($this->_getParam('rewritingMode') == "1")
		{
			$this->_restore = $match;
			return false;
		}
		else if(!$match && $this->_getParam('criteria') == "1")
		{
			$match = $this->_getParam('globalInclusions') ? 
				!$this->_matchParams($this->_getParam('globalInclusions')) : 
					!$this->_getParam('includeClasses');
			
		}

		return $match;
		
	}
	
	
	PRIVATE FUNCTION _getParam($param, $default = null)
	{
		static $settings;
		
		if(!$settings)
		{
			$settings = json_decode($this->params, true);
		}
		
		return array_key_exists($param, $settings) ? $settings[$param] : $default;
	}
	
}
