<?php
	
defined('_JEXEC') or die;

/** Extended Login and Registration for Joomla!
---------------------------------------------------------------
 Copyright (C) 2017 Addon Dev. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: November 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */

$app = JFactory::getApplication();

/* Set placeholder for username, password and secretekey */
$this->form->setFieldAttribute('username', 'hint', JText::_('COM_USERS_LOGIN_USERNAME_LABEL'));
$this->form->setFieldAttribute('password', 'hint', JText::_('JGLOBAL_PASSWORD'));
$this->form->setFieldAttribute('secretkey', 'hint', JText::_('JGLOBAL_SECRETKEY'));

?>

<form id="member-login" action="<?php echo JRoute::_('index.php?option=com_users&task=user.login'); ?>" method="post" class="form-validate">
	
	<h2 class="combined-header"><?php echo JText::_('JLOGIN'); ?></h2>
	
	<?php if ($description = ($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description')) != '') || $this->params->get('login_image') != '') : ?>
		<div class="login-description">
	<?php endif; ?>

		<?php if ($this->params->get('logindescription_show') == 1) : ?>
			<?php echo $this->params->get('login_description'); ?>
		<?php endif; ?>

		<?php if (($this->params->get('login_image') != '')) :?>
			<img src="<?php echo $this->escape($this->params->get('login_image')); ?>" class="login-image" alt="<?php echo JTEXT::_('COM_USERS_LOGIN_IMAGE_ALT')?>"/>
		<?php endif; ?>

	<?php if ($description) : ?>
		</div>
	<?php endif; ?>
	
	<?php foreach ($this->form->getFieldset('credentials') as $field) : ?>
		<?php if (!$field->hidden) : ?>	
			<div class="form-group">
				<div class="group-control">
					<?php echo $field->renderField(); ?>
				</div>
			</div>
		<?php endif; ?>
	<?php endforeach; ?>
	
	<?php if ($return = $app->input->get('return')) : ?>
		<input type="hidden" name="return" value="<?php echo $return; ?>">
	<?php endif; ?>
	
	<?php if ($this->tfa): ?>
		<div class="form-group">
			<div class="group-control">
				<?php echo $this->form->getField('secretkey')->input; ?>
			</div>
		</div>
	<?php endif; ?>

	<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
		<div class="checkbox">
			<label>
				<input id="remember" type="checkbox" name="remember" class="inputbox" value="yes">
				<?php echo JText::_('COM_USERS_LOGIN_REMEMBER_ME') ?>
			</label>
		</div>
	<?php endif; ?>

	<div class="form-group submit-btn">
		<button type="submit" class="btn btn-primary btn-block"><span class="icon-user"></span><span><?php echo JText::_('JLOGIN'); ?></span></button>
	</div>
	
	<div class="form-links">
		<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
		<?php echo JText::_('COM_USERS_LOGIN_RESET'); ?></a>
		&nbsp;
		<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
		<?php echo JText::_('COM_USERS_LOGIN_REMIND'); ?></a>
	</div>
	
	<?php echo JHtml::_('form.token'); ?>

</form>
