<?php

defined('_JEXEC') or die('Restricted access');

/** CSS Async Loader for Joomla!
---------------------------------------------------------------
 Copyright (C) 2015 Addon Dev. All rights reserved.
 Website: https://addondev.com
 GitHub: github.com/philip-sorokin
 Developer: Philip Sorokin
 E-mail: philip.sorokin@gmail.com
 Created: June 2015
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */

class PlgSystemCssasyncloader extends JPlugin
{
	
	PRIVATE 
		$_execute,
		$_scriptExecutionTime = false;
	
	
	PUBLIC FUNCTION __construct(&$subject, $config)
    {
		parent::__construct($subject, $config);
		$this->loadLanguage('', JPATH_ADMINISTRATOR);
    }
	
	
	PROTECTED FUNCTION isSite()
	{
		$app = JFactory::getApplication();
		
		return method_exists($app, 'isSite') ? $app->isSite() : $app->isClient('site');
	}
	
	
	PUBLIC FUNCTION onAfterDispatch()
	{
		if($this->isSite() && 
			JFactory::getDocument()->getType() === 'html' && !$this->_exclusions())
		{
			$this->_execute = true;
		}
	}
	
	
	PRIVATE FUNCTION _exclusions()
	{
		$match = false;
		
		if($globalExclusions = $this->params->get('globalExclusions'))
		{
			$list = explode(', ', $globalExclusions);
			$input = JFactory::getApplication()->input;
			
			foreach($list as $groups)
			{
				$params = explode('&', $groups);
				
				foreach($params as $nameValue)
				{
					$nameValue = explode('=', $nameValue);
					$name = $nameValue[0];
					
					if($values = isset($nameValue[1]) ? $nameValue[1] : null)
					{
						if(strpos($values, '(') === 0)
						{
							$values = substr($values, 1, strlen($values) - 2);
							$values = explode('|', $values);
						}
						else
						{
							$values = array($values);
						}
						
						foreach($values as $value)
						{
							if($match = $input->get($name) == $value)
							{
								break;
							}
						}
					}
					
					if(!$match)
					{
						break;
					}
					
				}
				
				if($match)
				{
					break;
				}
				
			}
			
		}

		return $match;
		
	}
	
	
	PUBLIC FUNCTION onAfterRender()
	{
		if($this->_execute)
		{
			if($this->_scriptExecutionTime = $this->params->get("scriptExecutionTime"))
			{
				$this->_countScriptExecutionTime();
			}
			
			$app = JFactory::getApplication();
			
			$html = $app->getBody();
			$mode = $this->params->get("mode");
			$input = implode("|", preg_split("#(\r\n|\r|\n)#", preg_quote($this->params->get("styleSheets"), '#'), -1, PREG_SPLIT_NO_EMPTY));
			
			if($mode || $input)
			{
				$exclusions = array();
				$styleSheets = array();
				$placeholder = "CSSAL_" . rand(0, 1000000);
				
				$html = preg_replace_callback("#<!--.+?-->#is", function($m) use ($placeholder, &$exclusions) {
					$exclusions[] = $m[0];
					return $placeholder;
				}, $html);
				
				$subpattern = "[^>]+?href\s*=\s*['\"][^'\"]*?";
				
				$rex = "#<link" . (
					"(?=[^>]+?rel\s*=\s*['\"]\s*stylesheet\s*['\"])" . (
						!$mode ? "(?=$subpattern(?:$input))" : ($input ? "(?!$subpattern(?:$input))" : "")
					)
				) . "\s+(.+?)\s*/?\s*>#is";
				
				$html = preg_replace_callback($rex, function($m) use (&$styleSheets)
				{
					preg_match_all("#([^\s=]+)(?:\s*=\s*['\"](.+?)['\"])?#s", $m[1], $styleSheet);
					
					foreach($styleSheet[2] as $key => $val)
					{
						$attr = &$styleSheet[1][$key];
						
						if (!strcasecmp($attr, 'href'))
						{
							$val = preg_replace("#^(?!(https?:)?//|/)#i", JUri::root(true) . '/', $val);
						}
						
						$attr = "'$attr':'{$val}'";
					}
					
					$styleSheets[] = "{" . implode(",", $styleSheet[1]) . "}";
					
					return "<noscript>" . $m[0] . "</noscript>";
					
				}, $html, -1, $cnt);
				
				if($cnt)
				{	
					$html = preg_replace('#</body\s*>#i', "<script type='text/javascript'>(function CSSAsyncLoader(a){'use strict'; function b(a,b){for(var c=0,d=a.length;d>c&&(!a[c]||!b(a[c]));c++);}var c=document.getElementsByTagName('head'),d=document.styleSheets;if(a instanceof Array&&c.length){var e=navigator.userAgent.match(/(?:(iP)(?:hone|ad|od).+?OS|(Android)|(MSIE)) (([0-9]+)[^0-9]([0-9]*))/);if(e)if(e[1])var f=3.2>(e[6]?e[5]+'.'+e[6]:e[5]);else e[2]?f=2.2>e[4]:e[3]&&(f=9>e[4]);b(a,function(a){var e=document.createElement('link');for(var g in a)e.setAttribute(g,a[g]);if(e.href&&!f){e.media='only async';var h=setInterval(function(){b(d,function(b){return b.href&&0 ===e.href.indexOf(b.href)?(clearInterval(h),e.media=a.media||'all',!0):void 0})},16)}c[0].appendChild(e)})}})([" . implode(",", $styleSheets) . "]);</script>$0", $html);	
				}
				
				if(!empty($exclusions))
				{
					$html = preg_replace_callback("#$placeholder#", function($m) use (&$exclusions) {
						return array_shift($exclusions);
					}, $html);
				}
				
			}
			
			$app->setBody($this->_scriptExecutionTime ? $this->_countScriptExecutionTime($html) : $html);
			
		}
	}
	
	
	PRIVATE FUNCTION _countScriptExecutionTime($html = null)
	{
		static $result = array(), $format = 5;
		
		$backtrace = debug_backtrace();
		$caller = $backtrace[1]['function'];
		
		$result[$caller] = !isset($result[$caller]) ? microtime(true) : 
			number_format((microtime(true) - $result[$caller]), $format);
		
		if($html)
		{
			$total = number_format((array_sum($result)), $format);
			$notice = __CLASS__ . ' (PHP script execution time):';
			
			if($this->_scriptExecutionTime == 1)
			{
				$notice = "\\n {$notice}";
				foreach($result as $name => $time)
				{
					$notice .= "\\n $name: $time sec.";
				}	
				$notice .= "\\n Total execution time: {$total} sec.";
				return preg_replace('#</head>#', "<script>if('console' in window && console.log) console.log('$notice')</script>$0", $html);
			}
			else
			{
				$notice = "<div><p style='margin: 15px; text-align: left'>{$notice}";
				foreach($result as $name => $time)
				{
					$notice .= "<br>$name: $time sec.";
				}	
				$notice .= "<br>total execution time: <b>{$total} sec.</b></div>";
				return preg_replace('#<body[^>]*>#', "$0{$notice}", $html);
			}
		}
		
	}

}
