<?php

defined('_JEXEC') or die('Restricted access');

/** CSS Async Loader for Joomla!
---------------------------------------------------------------
 Copyright (C) 2015 Addon Dev. All rights reserved.
 Website: https://addondev.com
 GitHub: github.com/philip-sorokin
 Developer: Philip Sorokin
 E-mail: philip.sorokin@gmail.com
 Created: June 2015
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */


class PlgSystemCssasyncloaderInstallerScript
{
	public function preflight($type, $parent)
	{
		$app = JFactory::getApplication();
		
		$minJVersion = '3.6';
		$minPHPVersion = '5.4';
		
		if(version_compare(JVERSION, $minJVersion, '<'))
		{
			$error = JText::sprintf('PLG_CSSASYNCLOADER_JOOMLA_VERSION_CHECK_FAILURE', $minJVersion);
		}
		
		if(version_compare(PHP_VERSION, $minPHPVersion, '<'))
		{
			if (isset($error)) {
				$error .= '<br/>';
			}
			$error .= JText::sprintf('PLG_CSSASYNCLOADER_PHP_VERSION_CHECK_FAILURE', $minPHPVersion);
		}
		
		if(isset($error))
		{
			$app->enqueueMessage($error, 'error');
			$parent->getParent()->message = '';
			return false;
		}
		
		$manifest = method_exists($parent, 'get') ? $parent->get('manifest') : $parent->getManifest();
		$update_server = (string) $manifest->updateservers->server;
		
		if($update_server && preg_match('#^((?:https?:)?//[^/]+/[^\?]+?\.\w+)(?:\?(.*))?#i', $update_server, $server))
		{
			$update_server_ref = $update_server;
			$ref = '_' . urlencode(JUri::getInstance()->getHost());
			
			if(!empty($server[2]) && strpos($update_server_ref, $ref) === false)
			{
				$update_server_ref .= $ref;
			}
			
			if(strcasecmp($update_server, $update_server_ref))
			{
				$manifest->updateservers->server = $update_server_ref;
				
				$xml = $manifest->asXML();
				JFile::write(__DIR__ . '/cssasyncloader.xml', $xml);
			}
		
			$dbo = JFactory::getDbo();
			
			$dbo->setQuery($dbo->getQuery(true)
				->SELECT('update_site_id')
				->FROM($dbo->quoteName('#__update_sites'))
				->WHERE($dbo->quoteName('location') . ' LIKE ' . $dbo->quote($server[1] . '%'))
				->WHERE($dbo->quoteName('location') . ' <> ' . $dbo->quote($update_server_ref))
			);
			
			if($update_ids = $dbo->loadObjectList())
			{
				foreach($update_ids as &$element)
				{
					$element = (int) $element->update_site_id;
				}
				
				$update_ids = implode(',', $update_ids);
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__update_sites'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__update_sites_extensions'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
				
				$dbo->setQuery($dbo->getQuery(true)
					->DELETE($dbo->quoteName('#__updates'))
					->WHERE($dbo->quoteName('update_site_id') . ' IN (' . $update_ids . ')')
				);
				$dbo->execute();
			}
		}
		
		if ($app->input->get('view') === 'update')
		{
			$parent->getParent()->message = '';
		}
	}
	
	public function postflight($type, $parent)
	{
	}
}
